<?php
/**
 * Intreface DAO
 *
 * @author: http://phpdao.com
 * @date: 2013-10-22 14:58
 */
interface MenuurlDAO{

	/**
	 * Get Domain object by primry key
	 *
	 * @param String $id primary key
	 * @Return Menuurl 
	 */
	public function load($id);

	/**
	 * Get all records from table
	 */
	public function queryAll();
	
	/**
	 * Get all records from table ordered by field
	 * @Param $orderColumn column name
	 */
	public function queryAllOrderBy($orderColumn);
	
	/**
 	 * Delete record from table
 	 * @param menuurl primary key
 	 */
	public function delete($menuurlid);
	
	/**
 	 * Insert record to table
 	 *
 	 * @param Menuurl menuurl
 	 */
	public function insert($menuurl);
	
	/**
 	 * Update record in table
 	 *
 	 * @param Menuurl menuurl
 	 */
	public function update($menuurl);	

	/**
	 * Delete all rows
	 */
	public function clean();

	public function queryByUrltitle($value);

	public function queryByMenuurl($value);

	public function queryByUrlimage($value);

	public function queryByUsergroupid($value);


	public function deleteByUrltitle($value);

	public function deleteByMenuurl($value);

	public function deleteByUrlimage($value);

	public function deleteByUsergroupid($value);


}
?>